﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Comfile.Cubloc.Download;
using System.IO;
using System.Diagnostics;
using System.Threading.Tasks;
using System.IO.Ports;
using System.Globalization;
using System.Reflection;

namespace Comfile.Cubloc.Download.Test
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            this.Text = "Cubloc Downloader v" + Assembly.GetExecutingAssembly().GetName().Version.ToString();

            foreach (string portName in SerialPort.GetPortNames())
            {
                _portComboBox.Items.Add(portName);
            }

            if (_portComboBox.Items.Count > 0)
            {
                _portComboBox.SelectedIndex = 0;
            }

            EnableUI();
        }

        private void _queryDeviceButton_Click(object sender, EventArgs e)
        {
            DisableUI();

            CublocDeviceInfo device = null;
            using (CublocDownloader downloader = CublocDownloader.Open(_portComboBox.SelectedItem.ToString()))
            {
                try
                {
                    device = downloader.QueryDevice();

                    _modelLabel.Text = device.Model.ToString();
                    _firmwareValidationCodeLabel.Text = device.FirmwareValidationCode.ToString("X");
                    _isWriteDisabledLabel.Text = device.IsWriteDisabled.ToString();
                }
                catch (Exception ex)
                {
                    MessageBox.Show("QueryDevice failed: " + ex.Message);
                }
            }

            EnableUI();
        }

        private void _firmwareDownloadButton_Click(object sender, EventArgs e)
        {
            DisableUI();

            Task t = new Task((object state) =>
            {
                try
                {
                    using (CublocDownloader downloader = CublocDownloader.Open(state.ToString()))
                    {
                        downloader.DownloadFirmware(_firmwareFileTextBox.Text, ReportMessage, ReportProgress);
                    }

                    ReportMessage("Finished");
                }
                catch (Exception ex)
                {
                    ReportMessage("Failed: " + ex.Message);
                }
                finally
                {
                    EnableUI();
                }
            }, _portComboBox.SelectedItem.ToString());
            t.Start();
        }

        private void _programDownloadButton_Click(object sender, EventArgs e)
        {
            DisableUI();

            Task t = new Task((object state) =>
            {
                try
                {
                    using (CublocDownloader downloader = CublocDownloader.Open(state.ToString()))
                    {
                        downloader.DownloadProgram(_programFileTextBox.Text, ReportMessage, ReportProgress);
                    }

                    ReportMessage("Finished");
                }
                catch (Exception ex)
                {
                    ReportMessage("Failed: " + ex.Message);
                }
                finally
                {
                    EnableUI();
                }
            }, _portComboBox.SelectedItem.ToString());
            t.Start();
        }

        private void ReportMessage(string message)
        {
            label1.BeginInvoke(new Action(() =>
            {
                label1.Text = message;
            }));
        }

        private void ReportProgress(uint percent)
        {
            progressBar1.BeginInvoke(new Action(() =>
            {
                progressBar1.Value = Convert.ToInt32(percent);
            }));
        }

        private void _firmwareFileBrowseButton_Click(object sender, EventArgs e)
        {
            DialogResult result = openFileDialog1.ShowDialog();
            if (result == DialogResult.OK)
            {
                _firmwareFileTextBox.Text = openFileDialog1.FileName;
            }
        }

        private void _programFileBrowseButton_Click(object sender, EventArgs e)
        {
            DialogResult result = openFileDialog1.ShowDialog();
            if (result == DialogResult.OK)
            {
                _programFileTextBox.Text = openFileDialog1.FileName;
            }
        }

        private void EnableUI()
        {
            this.Invoke(new Action(() =>
                {
                    _firmwareDownloadButton.Enabled = !string.IsNullOrWhiteSpace(_firmwareFileTextBox.Text);
                    _programDownloadButton.Enabled = !string.IsNullOrWhiteSpace(_programFileTextBox.Text); ;
                }));
        }

        private void DisableUI()
        {
            this.Invoke(new Action(() =>
            {
                _firmwareDownloadButton.Enabled = false;
                _programDownloadButton.Enabled = false;
            }));
        }

        private void _firmwareFileTextBox_TextChanged(object sender, EventArgs e)
        {
            EnableUI();
        }

        private void _programFileTextBox_TextChanged(object sender, EventArgs e)
        {
            EnableUI();
        }

          
    }
}
